async function equipItem(bot, name) {
    // return if name is not string
    if (typeof name !== "string") {
        throw new Error("name for equipItem must be a string");
    }

    const itemByName = mcData.itemsByName[name];
    if (!itemByName) {
        throw new Error(`No item named ${name}`);
    }

    const item = bot.inventory.findInventoryItem(itemByName.id);

    if (!item) {
        bot.chat(`No ${name} in inventory`);
        return;
    }

    let destination;

    // Determine the equipment slot based on the item name
    if (name.includes("helmet")) {
        destination = "head";
    } else if (name.includes("chestplate")) {
        destination = "torso";
    } else if (name.includes("leggings")) {
        destination = "legs";
    } else if (name.includes("boots")) {
        destination = "feet";
    } else {
        destination = "hand";
    }

    // Equip the item in the appropriate slot
    try {
        await bot.equip(item, destination);
        bot.chat(`Equipped ${name} in ${destination}`);
    } catch (err) {
        bot.chat(`Failed to equip ${name}: ${err.message}`);
    }
}